
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   ZCONS.H - Zodiac Constant Definitions
// 
//
//   DESCRIPTION
//
//   Definitions of constants used in Zodiac message processing.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\ZCONS.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:56   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.4   Jul 09 1997 10:32:52   COLEJ
//    
//   
//      Rev 1.3   Feb 25 1997 14:40:46   COLEJ
//   deleted old D2M constant - was bad programming
//   
//      Rev 1.2   Feb 12 1997 16:04:52   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:21:14   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:32   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////


// conversions and scale factors

#define UNITY    1              // one
#define R42D     .0180/PI       // radians * 1E+04 to degrees
//#define D2M      110865.92      // assumes 24,800 mile circumference for earth   - not good method
#define MPS2KN   1.8367347      // meters/sec to knots
                     
#define TWOP8     pow(2,  8)    // 2^8
#define TWOP10    pow(2, 10)    // 2^10
#define TWOP15    pow(2, 15)    // 2^15
#define TWOP18    pow(2, 18)    // 2^18
#define TWOP19    pow(2, 19)    // 2^19
#define TWOP29    pow(2, 29)    // 2^29 
#define TWOP31    pow(2, 31)    // 2^31 
#define TWOP35    pow(2, 35)    // 2^35 
#define TWOP41    pow(2, 41)    // 2^41
#define TWOP45    pow(2, 45)    // 2^45
#define TWOP47    pow(2, 47)    // 2^47
#define TWOP50    pow(2, 50)    // 2^50
#define X50TWOP19 50. * TWOP19  // 50 * 2^19
#define X50TWOP29 50. * TWOP29  // 50 * 2^29
#define X50TWOP45 50. * TWOP45  // 50 * 2^45
                        
// zodiac binary header bits   
                        
#define D_BIT  0x8000  // disconnect bit
#define C_BIT  0x4000  // connect bit
#define L_BIT  0x2000  // log request bit
#define E_BIT  0x1000  // extended log request bit
#define Q_BIT  0x0800  // query bit
#define R_BIT  0x0400  // request acknowledge bit
#define A_BIT  0x0200  // acknowledge bit
#define N_BIT  0x0100  // negative-acknowledge bit
                        
#define ID_TAG 0x003F  // 6-bit user-specified id tag
                        
#define ANREQ   (R_BIT | A_BIT | N_BIT) // request an ack/nack
                        
                        
                        
                        